<?php

namespace App\Services;

class RootInterpretationService
{
    private array $rootInterpretations = [
        1 => [
            'title' => 'SENDIRI (Independent Leader)',
            'traits' => 'Bijak, natural born leader/pemimpin, kreatif, banyak idea baru, pandai analisa orang (baca orang), Berani, berdikari, positif, individualistic, agresif, perfectionist, keras kepala, sentiasa nak menang, ego, sangat dominan dalam perhubungan, dingin, sangat sensitive, sentiasa rasa betul, expectation yang tinggi, berterus terang.',
            'element' => 'LOGAM/BESI',
            'strengths' => 'Pemimpin semulajadi, keyakinan diri yang tinggi, bercita-cita tinggi',
            'challenges' => 'Terlalu mengongkong, pendiam, sangat spontan',
            'desires' => 'Mahu perhatian orang ramai, mencuba idea baru',
            'career' => 'Ahli politik, artis, pemilik perniagaan'
        ],
        2 => [
            'title' => 'SUARA (Voice/Harmony)',
            'traits' => 'Lembut, pembersih, jujur, tenang, dengar kata tapi tidak semestinya buat, memahami, sabar, mudah untuk berkawan, boleh diajak berbincang/diplomasi, suka bersimpati, boleh dipercayai, mudah memaafkan, pemalu, terlampau sensitive, depressi, tiada cita-cita, kurang bijak, sukar untuk buat keputusan dan tidak tetap dalam membuat keputusan, seseorang emotional.',
            'element' => 'AIR',
            'strengths' => 'Penyayang pendiam, analitikal, rakan yang ideal',
            'challenges' => 'Tidak mahu maju atau bersuara, berdiam diri, tidak suka butiran kecil, kesunyian',
            'desires' => 'Mahu hubungan, sempurna, keharmonian dan kemas',
            'career' => 'Diplomat kaunselor, rakan niaga'
        ],
        3 => [
            'title' => 'AKTIF (Active/Creative)',
            'traits' => 'Menawan semasa muda, menarik, aktif, cepat menyiapkan tugas tapi tidak sempurna, baran agresif, kurang tegas, perhubungan rapuh, mudah berkawan, bernafsu tinggi, suka mengikut trend, seorang yang mudah teruja, bersemangat, kreatif, artistic, egois, suka mengawal kritikal.',
            'element' => 'API',
            'strengths' => 'Ceria, peramah, imaginasi, bersungguh-sungguh',
            'challenges' => 'Tidak suka kerja rutin, kurang disiplin, kurang berjaya',
            'desires' => 'Menggerakkan tenaga dan idea, mahu keseronokan hidup',
            'career' => 'Setiausaha, perancang majlis, promoter bisnes'
        ],
        4 => [
            'title' => 'PERANCANG/ILMU (Planner/Knowledge)',
            'traits' => 'Kemahiran yang tinggi, bijak tidak mudah putus asa, perhubungan yang mudah putus, sukar simpan wang, bangga, suka bersangka buruk pada orang lain, konservatif, rajin, keras kepala, kedekut, praktikal, setia, logikal, suka pada benda rutin, tetap, mahukan sekuriti, tidak berani ambil risiko.',
            'element' => 'KAYU',
            'strengths' => 'Kerja keras, praktikal, siapkan kerja',
            'challenges' => 'Takut diasingkan, tiada rutin biasa, tidak fleksibal',
            'desires' => 'Mahu keselamatan, cipta undang-undang',
            'career' => 'Pengurus, penyokong pasukan belakang tabir'
        ],
        5 => [
            'title' => 'MENCARI/ARAH (Seeker/Direction)',
            'traits' => 'Pemimpin, berpangkat tinggi, kerja keras, seorang yang degil, adventurous, bertenaga, bernafsu tinggi, bercita rasa tinggi, bijak sana, charming, berfikiran jauh, berani mengambil risiko, suka/minat berniaga, boros suka shopping dan kuat berbelanja, moody, tak consistent, jealousy, seksi, berkira, suka bertangguh.',
            'element' => 'TANAH',
            'strengths' => 'Sangat berani dan mudah meyakinkan',
            'challenges' => 'Mudah bosan, resah, mudah dipengaruhi',
            'desires' => 'Cari peluang baru, berani ambil risiko, mahu cuba segalanya',
            'career' => 'Perhatian Umum, media, mencipta idea-idea baru'
        ],
        6 => [
            'title' => 'WANG (Wealth/Management)',
            'traits' => 'Citarasa mewah, kawal wang, berdikari, mahu menguasai tidak mementingkan diri sendiri, pendamai, charming, suka duduk rumah, bijak, menegakkan keadilan, berperikemanusiaan, jujur, penyayang, mengambil berat, tamak.',
            'element' => 'LOGAM/BESI',
            'strengths' => 'Penyayang, pengasuh, suka berkeluarga, boleh diharap',
            'challenges' => 'Rasa rendah diri, mudah semput pemikiran',
            'desires' => 'Ambil berat tentang orang tersayang, keselamatan dan keselesaan',
            'career' => 'Pembantu peribadi, pendidik, penyelia'
        ],
        7 => [
            'title' => 'KAWAN/PENGIKUT (Friend/Follower)',
            'traits' => 'Cerewet, bertelagah, popular, berdikari, tarik penyokong, mistik, berfalsafah, artistic, pendendam, kesunyian, moody, depressi, mengira, pemalas, suka mengasingkan diri, suka berfikir, analitikal, kekuatan kerohanian.',
            'element' => 'AIR',
            'strengths' => 'Pemikir yang hebat, berfalsafah, unik, pelik',
            'challenges' => 'Kurang peramah, takut tidak capai tahap hidup yang tinggi, kesunyian',
            'desires' => 'Mencari jawapan persoalan hidup, memerhati, menyelidik',
            'career' => 'Bidang analitikal kerja sendiri'
        ],
        8 => [
            'title' => 'TANGGUNGJAWAB & TEKANAN (Responsibility & Pressure)',
            'traits' => 'Pendiam tapi ramai kawan, bertanggungjawab, dipercayai, pertahankan kawan, suka kepada kebebasan dan kuasa, keras kepala, bersifat kepimpinan, suka terurus, suka membantu, baik hati, memahami, ambitious, gila wang, egois, dictator, mudah tertekan, 6th sense yang kuat.',
            'element' => 'API',
            'strengths' => 'Berpengaruh, berbakat, mendesak, bagus dengan wang',
            'challenges' => 'Kurang senang dengan orang yang menghalangnya',
            'desires' => 'Berusaha gigih, mahu mendapat kuasa dan status',
            'career' => 'Bidang professional, pengurus bisnes francais'
        ],
        9 => [
            'title' => 'KEJAYAAN (Success)',
            'traits' => 'Seorang yang bergaya, kemas, pandai PR (Public Relation), tarik simpati orang tua, kesunyian, bijak, suka memberi, passionate, berfalsafah, sensitive, ikhlas, berbakat, romantis, bersifat kepimpinan, memahami, emosi yang berlebihan, penyayang.',
            'element' => 'KAYU',
            'strengths' => 'Bersemangat, cergas, kreatif, mahu berbakti kepada dunia',
            'challenges' => 'Elakkan sifat buruk dan perhatikan butiran hidup',
            'desires' => 'Mahu melihat dunia, mencapai impian',
            'career' => 'Ketua masyarakat, perancang bisnes'
        ]
    ];

    public function getInterpretation(int $rootNumber): ?array
    {
        return $this->rootInterpretations[$rootNumber] ?? null;
    }

    public function getAllInterpretations(): array
    {
        return $this->rootInterpretations;
    }
}