<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NumerologyCalculation extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'name',
        'birthdate',
        'industry',
        'L5',
        'L6',
        'L7',
        'L8',
        'L9',
        'root_number',
        'swot_combinations',
    ];

    protected $casts = [
        'birthdate' => 'date',
        'L5' => 'array',
        'L6' => 'array',
        'L7' => 'array',
        'L8' => 'array',
        'L9' => 'array',
        'swot_combinations' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
