<?php

namespace App\Services;

class BusinessGuidanceService
{
    private array $businessCategories = [
        'LOGAM/BESI' => [
            'category' => 'Metal/Finance',
            'businesses' => 'Kewangan, Perbankan, Komponen Elektronik, Kejuruteraan, peralatan besi, guaman, seni silat, barangan kemas/aksesori, dunia automotif, Pengangkutan/logistik/pelancongan, Pegawai Kerajaan, Polis, Tentera, Penguatkuasa'
        ],
        'AIR' => [
            'category' => 'Water/Service', 
            'businesses' => 'Dunia komunikasi, barangan pengguna, Pemborong Eksport Import, Kimia, Perkapalan, logistik laluan laut, Hotel, Perkhidmatan, Dobi, Makanan laut, penternakan haiwan akuatik'
        ],
        'API' => [
            'category' => 'Fire/Energy',
            'businesses' => 'Dunia lakonan/hiburan, Pengiklanan, Kecantikan/Salun/Kosmetik, Dunia Janakuasa/Tenaga, Dunia Pencahayaan/Laser, Elektronik, Hiasan Dalaman, Psikologi, Restoran, Telekomunikasi, Komputer, Minyak dan Gas'
        ],
        'KAYU' => [
            'category' => 'Wood/Education',
            'businesses' => 'Pertanian/perladangan, Kesenian, Penyelidikan, Pendidikan, Fesyen, Perubatan, Kedai buku, Perpustakaan, muzik, Penulisan, Percetakan dan Penerbitan, Kilang kotak, Perkhidmatan masyarakat, Fabrik, Tekstil, Herba'
        ],
        'TANAH' => [
            'category' => 'Earth/Leadership',
            'businesses' => 'Arkitek, Kontraktor, Kejuruteraan sivil, Barangan Tembikar/ceramik/Jubin, Perlombongan, Hartanah, Kuari, Konsultansi, Pentadbiran, Politik'
        ]
    ];

    private array $learningStyles = [
        1 => ['style' => 'KINESTETIK (BESI)', 'approach' => 'Hands-on learning, practical application, direct experience'],
        2 => ['style' => 'VISUAL (AIR)', 'approach' => 'Visual aids, charts, diagrams, written instructions'],
        3 => ['style' => 'AUDIO (API)', 'approach' => 'Verbal discussions, music, sound-based learning'],
        4 => ['style' => 'DIGITAL (KAYU)', 'approach' => 'Structured information, step-by-step processes, logical sequences'],
        5 => ['style' => 'FLEXIBLE (TANAH)', 'approach' => 'Varied approaches, leadership roles, dynamic environments'],
        6 => ['style' => 'KINESTETIK (BESI)', 'approach' => 'Hands-on learning, practical application, direct experience'],
        7 => ['style' => 'VISUAL (AIR)', 'approach' => 'Visual aids, charts, diagrams, written instructions'],
        8 => ['style' => 'AUDIO (API)', 'approach' => 'Verbal discussions, music, sound-based learning'],
        9 => ['style' => 'DIGITAL (KAYU)', 'approach' => 'Structured information, step-by-step processes, logical sequences']
    ];

    public function getBusinessGuidance(string $element, ?string $industry = null): array
    {
        $guidance = [
            'element_category' => $this->businessCategories[$element]['category'] ?? 'Unknown',
            'suitable_businesses' => $this->businessCategories[$element]['businesses'] ?? 'No guidance available',
            'industry_specific' => null
        ];

        if ($industry) {
            $guidance['industry_specific'] = $this->getIndustrySpecificGuidance($element, $industry);
        }

        return $guidance;
    }

    public function getLearningStyle(int $rootNumber): ?array
    {
        return $this->learningStyles[$rootNumber] ?? null;
    }

    private function getIndustrySpecificGuidance(string $element, string $industry): string
    {
        $industryLower = strtolower($industry);
        $elementGuidance = $this->businessCategories[$element]['businesses'] ?? '';

        // Check if the provided industry aligns with the element
        if (stripos($elementGuidance, $industry) !== false) {
            return "Your industry ($industry) aligns well with your $element element. This suggests natural aptitude and potential for success in this field.";
        } else {
            return "Your industry ($industry) may not be the most natural fit for your $element element. Consider how you can leverage your element's strengths: " . $this->businessCategories[$element]['businesses'];
        }
    }

    public function getAllBusinessCategories(): array
    {
        return $this->businessCategories;
    }

    public function getAllLearningStyles(): array
    {
        return $this->learningStyles;
    }
}