<?php

namespace App\Services;

class SWOTCombinationService
{
    private array $swotCombinations = [
        '123' => ['label' => 'S', 'description' => 'Kekuatan pada suara (penyanyi,guru, sales, marketing, usahawan)'],
        '426' => ['label' => 'S', 'description' => 'Pandai syarahan / ceramah / pendidikan'],
        '246' => ['label' => 'S', 'description' => 'Pandai syarahan / ceramah / pendidikan'],
        '729' => ['label' => 'S', 'description' => 'Sangat menawan dan mudah yakin/tarikan orang, karisma "Pelaris"'],
        '279' => ['label' => 'S', 'description' => 'Sangat menawan dan mudah yakin/tarikan orang, karisma "Pelaris"'],
        '573' => ['label' => 'W', 'description' => 'Berpengaruh, mudah bergaul dengan kenamaan dan tertinggi/ koprat atau orang atas duit habis sebab di ambil orang atau berbelanja untuk orang kenamaan atau orang atas. Mudah disabotaj orang.'],
        '56' => ['label' => 'S', 'description' => 'Sangat berhati-hati dengan wang (sesuai jadi pegawai kewangan)'],
        '666' => ['label' => 'S', 'description' => 'Sangat berhati-hati dengan wang (sesuai jadi pegawai kewangan)'],
        '966' => ['label' => 'O', 'description' => 'Mudah untung (bagus jadi usahawan)'],
        '336' => ['label' => 'T', 'description' => 'Positif, pergerakan wang yang aktif Negatif, boros kerana duit "panas"'],
        '663' => ['label' => 'W', 'description' => 'Aliran wang tunai terlalu cepat'],
        '393' => ['label' => 'T', 'description' => 'Kejayaan yang singkat (positif-cepat berjaya negatif- tak bertahan lama)'],
        '933' => ['label' => 'T', 'description' => 'Kejayaan yang singkat (positif-cepat berjaya negatif- tak bertahan lama)'],
        '119' => ['label' => 'W', 'description' => 'Sangat berdikari, tidak boleh jadi rakan niaga, suka conquer, Rasa kesunyian dan sendirian'],
        '191' => ['label' => 'W', 'description' => 'Sangat berdikari, tidak boleh jadi rakan niaga, suka conquer, Rasa kesunyian dan sendirian'],
        '843' => ['label' => 'O', 'description' => 'Selalu tercari-cari kejayaan, mudah bosan ,tamakkan peluang, sentiasa ingin tukar citarasa maka duit habis. Terdapat pada orang MLM. Banyak idea dan inovatif.'],
        '456' => ['label' => 'T', 'description' => 'Terlibat/bertanggungjawab di dalam aliran wang (mudah untuk terlibat dengan rasuah jika lalai.'],
        '111' => ['label' => 'T', 'description' => 'Mudah depressi/sakit jiwa/tekanan emosi'],
        '6666' => ['label' => 'T', 'description' => 'Impak dengan besi (kemalangan,pembedahan)'],
        '222' => ['label' => 'S', 'description' => 'Dikelilingi wanita , dibiayai wanita, mudah rapat dengan wanita'],
        '777' => ['label' => 'S', 'description' => 'Dikelilingi lelaki (jiwa wanita)/ Network kuat'],
        '999' => ['label' => 'O', 'description' => 'Banyak peluang dan kejayaan tetapi kesunyian suka tinggal dikawasan bukit berhutan'],
        '888' => ['label' => 'T', 'description' => 'Terlalu "panas"- Hiperaktif'],
        '333' => ['label' => 'T', 'description' => 'Terlalu "panas"- Agresif, pendendam'],
        '11' => ['label' => 'W', 'description' => 'Sangat berdikari, namun"ditikam belakang" Berjauhan (mental/fizikal) boleh berpisah/bercerai'],
        '459' => ['label' => 'O', 'description' => 'Mempunyai gerak hati atau muslihat, ilham, dunia kecantikan & Kesihatan'],
        '944' => ['label' => 'S', 'description' => 'Pengasas / Penerbitan / Rekacipta (Masakan, Fesyen), Herba, Kecantikan, pertanian, dunia akademik.'],
        '235' => ['label' => 'W', 'description' => 'Beremosi, mudah terusik, baran'],
        '786' => ['label' => 'O', 'description' => 'Orang yang suka beri tanggungjawab (kelebihan dan mudah rezekinya'],
        '156' => ['label' => 'S', 'description' => 'Bekerja diluar (outstation )'],
        '189' => ['label' => 'S', 'description' => 'Bergerak sana sini, tidak duduk satu tempat'],
        '83' => ['label' => 'W', 'description' => 'Selalu keluar dan tiada dirumah / di pejabat'],
        '71' => ['label' => 'W', 'description' => 'Mudah ditipu orang/ terlalu mudah percayakan orang'],
        '73' => ['label' => 'W', 'description' => 'Orang mudah datang dan pergi/ orang mudah takut dengan anda'],
        '37' => ['label' => 'W', 'description' => 'Orang mudah datang dan pergi/ orang mudah takut dengan anda'],
        '67' => ['label' => 'W', 'description' => 'Mudah kasihan kepada orang / mudah belanja orang'],
    ];

    public function findSWOTCombinations(array $L6, array $L7, array $L8, array $L9): array
    {
        // Create a 7x4 grid representing the pyramid structure
        $grid = $this->createGrid($L6, $L7, $L8, $L9);
        
        $foundCombinations = [];

        // Check all possible sequences in the grid
        for ($row = 0; $row < 4; $row++) {
            for ($col = 0; $col < 7; $col++) {
                if ($grid[$row][$col] !== null) {
                    // Check all 8 directions for sequences of length 2, 3, and 4
                    $this->checkSequencesFromPosition($grid, $row, $col, $foundCombinations);
                }
            }
        }

        return $foundCombinations;
    }

    private function createGrid(array $L6, array $L7, array $L8, array $L9): array
    {
        // Initialize 4x7 grid with null values
        $grid = array_fill(0, 4, array_fill(0, 7, null));

        // L6 (row 0): 4 elements centered
        $grid[0][1] = $L6[0];
        $grid[0][2] = $L6[1];
        $grid[0][4] = $L6[2];
        $grid[0][5] = $L6[3];

        // L7 (row 1): 2 elements centered
        $grid[1][2] = $L7[0];
        $grid[1][4] = $L7[1];

        // L8 (row 2): 7 elements
        for ($i = 0; $i < 7; $i++) {
            $grid[2][$i] = $L8[$i];
        }

        // L9 (row 3): 3 elements centered
        $grid[3][1] = $L9[0];
        $grid[3][3] = $L9[1];
        $grid[3][5] = $L9[2];

        return $grid;
    }

    private function checkSequencesFromPosition(array $grid, int $startRow, int $startCol, array &$foundCombinations): void
    {
        // 8 directions: right, down, diagonal down-right, diagonal down-left, 
        // left, up, diagonal up-left, diagonal up-right
        $directions = [
            [0, 1],   // right
            [1, 0],   // down
            [1, 1],   // diagonal down-right
            [1, -1],  // diagonal down-left
            [0, -1],  // left
            [-1, 0],  // up
            [-1, -1], // diagonal up-left
            [-1, 1],  // diagonal up-right
        ];

        foreach ($directions as $direction) {
            [$dRow, $dCol] = $direction;
            
            // Check sequences of length 2, 3, and 4
            for ($length = 2; $length <= 4; $length++) {
                $sequence = [];
                $positions = [];
                
                for ($i = 0; $i < $length; $i++) {
                    $row = $startRow + ($i * $dRow);
                    $col = $startCol + ($i * $dCol);
                    
                    // Check bounds
                    if ($row < 0 || $row >= 4 || $col < 0 || $col >= 7 || $grid[$row][$col] === null) {
                        break;
                    }
                    
                    $sequence[] = $grid[$row][$col];
                    $positions[] = [$row, $col];
                }

                if (count($sequence) === $length) {
                    $sequenceString = implode('', $sequence);
                    
                    // Check if this sequence matches any SWOT combination
                    if (isset($this->swotCombinations[$sequenceString])) {
                        $combo = $this->swotCombinations[$sequenceString];
                        
                        // Avoid duplicates
                        $isDuplicate = false;
                        foreach ($foundCombinations as $existing) {
                            if ($existing['sequence'] === $sequenceString && 
                                $existing['cells'] === $positions) {
                                $isDuplicate = true;
                                break;
                            }
                        }
                        
                        if (!$isDuplicate) {
                            $foundCombinations[] = [
                                'sequence' => $sequenceString,
                                'base_combo' => $sequenceString,
                                'label' => $combo['label'],
                                'description' => $combo['description'],
                                'cells' => $positions,
                            ];
                        }
                    }
                }
            }
        }
    }
}