import React from 'react';
import { Loader } from 'lucide-react';

interface LoadingSpinnerProps {
  size?: 'sm' | 'md' | 'lg' | 'xl';
  text?: string;
  className?: string;
}

const LoadingSpinner: React.FC<LoadingSpinnerProps> = ({ 
  size = 'md', 
  text,
  className = ''
}) => {
  const sizeClasses = {
    sm: 'h-4 w-4',
    md: 'h-6 w-6',
    lg: 'h-8 w-8',
    xl: 'h-12 w-12'
  };

  const containerClasses = {
    sm: 'space-x-2',
    md: 'space-x-2',
    lg: 'space-x-3',
    xl: 'space-x-4'
  };

  return (
    <div className={`flex items-center justify-center ${containerClasses[size]} ${className}`}>
      <Loader className={`${sizeClasses[size]} animate-spin text-purple-600`} />
      {text && (
        <span className={`text-purple-600 ${
          size === 'sm' ? 'text-sm' :
          size === 'md' ? 'text-base' :
          size === 'lg' ? 'text-lg' :
          'text-xl'
        }`}>
          {text}
        </span>
      )}
    </div>
  );
};

export default LoadingSpinner;