import api, { 
  ApiResponse, 
  CalculationResult, 
  RootInterpretation, 
  SavedCalculation 
} from './api';

export interface CalculateNumerologyRequest {
  name: string;
  birthdate: string;
  industry?: string;
}

export interface SaveCalculationRequest {
  calculation: any;
  swot_combinations?: any[];
  interpretation?: any;
  business_guidance?: any;
  learning_style?: any;
}

class NumerologyService {
  async calculateNumerology(data: CalculateNumerologyRequest): Promise<CalculationResult> {
    const response = await api.post<ApiResponse<CalculationResult>>('/calculate-numerology', data);
    
    if (!response.data.success || !response.data.data) {
      throw new Error(response.data.message || 'Calculation failed');
    }
    
    return response.data.data;
  }

  async getInterpretation(rootNumber: number): Promise<RootInterpretation> {
    const response = await api.get<ApiResponse<RootInterpretation>>(`/interpretations/${rootNumber}`);
    
    if (!response.data.success || !response.data.data) {
      throw new Error(response.data.message || 'Failed to get interpretation');
    }
    
    return response.data.data;
  }

  async saveCalculation(data: SaveCalculationRequest): Promise<SavedCalculation> {
    const response = await api.post<ApiResponse<SavedCalculation>>('/save-calculation', data);
    
    if (!response.data.success || !response.data.data) {
      throw new Error(response.data.message || 'Failed to save calculation');
    }
    
    return response.data.data;
  }

  async getUserCalculations(): Promise<SavedCalculation[]> {
    const response = await api.get<ApiResponse<SavedCalculation[]>>('/my-calculations');
    
    if (!response.data.success || !response.data.data) {
      throw new Error(response.data.message || 'Failed to get calculations');
    }
    
    return response.data.data;
  }

  async deleteCalculation(id: number): Promise<void> {
    const response = await api.delete<ApiResponse<void>>(`/calculations/${id}`);
    
    if (!response.data.success) {
      throw new Error(response.data.message || 'Failed to delete calculation');
    }
  }
}

export const numerologyService = new NumerologyService();
export default numerologyService;