export const SWOT_COLORS = {
  S: 'bg-green-100 border-green-500 text-green-800',
  W: 'bg-red-100 border-red-500 text-red-800',
  O: 'bg-blue-100 border-blue-500 text-blue-800',
  T: 'bg-yellow-100 border-yellow-500 text-yellow-800',
} as const;

export const SWOT_LABELS = {
  S: 'Strengths',
  W: 'Weaknesses',
  O: 'Opportunities',
  T: 'Threats',
} as const;

export const ELEMENT_COLORS = {
  'LOGAM/BESI': 'bg-gray-100 text-gray-800',
  'AIR': 'bg-blue-50 text-blue-800',
  'API': 'bg-red-50 text-red-800',
  'KAYU': 'bg-green-50 text-green-800',
  'TANAH': 'bg-yellow-50 text-yellow-800',
} as const;

export const DATE_FORMAT_EXAMPLES = [
  '31-July-1985',
  '31/07/1985',
  '31 July 1985',
  '31-07-1985',
] as const;

export const SUPPORTED_LANGUAGES = [
  { value: 'ms', label: 'Bahasa Malaysia' },
  { value: 'en', label: 'English' },
] as const;

export const COMMON_INDUSTRIES = [
  'Sales',
  'Marketing',
  'Technology',
  'Finance',
  'Healthcare',
  'Education',
  'Retail',
  'Manufacturing',
  'Consulting',
  'Real Estate',
  'Entertainment',
  'Food & Beverage',
  'Transportation',
  'Construction',
  'Agriculture',
] as const;

export const ROOT_NUMBER_RANGE = {
  MIN: 1,
  MAX: 9,
} as const;