<?php

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\NumerologyController;
use App\Http\Controllers\Api\UserController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

// Public routes
Route::post('/calculate-numerology', [NumerologyController::class, 'calculate']);
Route::get('/interpretations/{root_number}', [NumerologyController::class, 'getInterpretation']);

// Authentication routes
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    
    // Numerology routes
    Route::post('/save-calculation', [NumerologyController::class, 'saveCalculation']);
    Route::get('/my-calculations', [NumerologyController::class, 'getUserCalculations']);
    Route::delete('/calculations/{id}', [NumerologyController::class, 'deleteCalculation']);
    
    // User profile routes
    Route::get('/profile', [UserController::class, 'getProfile']);
    Route::put('/profile', [UserController::class, 'updateProfile']);
});