import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\NumerologyController::calculate
* @see app/Http/Controllers/Api/NumerologyController.php:19
* @route '/api/calculate-numerology'
*/
export const calculate = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: calculate.url(options),
    method: 'post',
})

calculate.definition = {
    methods: ["post"],
    url: '/api/calculate-numerology',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\NumerologyController::calculate
* @see app/Http/Controllers/Api/NumerologyController.php:19
* @route '/api/calculate-numerology'
*/
calculate.url = (options?: RouteQueryOptions) => {
    return calculate.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\NumerologyController::calculate
* @see app/Http/Controllers/Api/NumerologyController.php:19
* @route '/api/calculate-numerology'
*/
calculate.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: calculate.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::calculate
* @see app/Http/Controllers/Api/NumerologyController.php:19
* @route '/api/calculate-numerology'
*/
const calculateForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: calculate.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::calculate
* @see app/Http/Controllers/Api/NumerologyController.php:19
* @route '/api/calculate-numerology'
*/
calculateForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: calculate.url(options),
    method: 'post',
})

calculate.form = calculateForm

/**
* @see \App\Http\Controllers\Api\NumerologyController::getInterpretation
* @see app/Http/Controllers/Api/NumerologyController.php:62
* @route '/api/interpretations/{root_number}'
*/
export const getInterpretation = (args: { root_number: string | number } | [root_number: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getInterpretation.url(args, options),
    method: 'get',
})

getInterpretation.definition = {
    methods: ["get","head"],
    url: '/api/interpretations/{root_number}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\NumerologyController::getInterpretation
* @see app/Http/Controllers/Api/NumerologyController.php:62
* @route '/api/interpretations/{root_number}'
*/
getInterpretation.url = (args: { root_number: string | number } | [root_number: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { root_number: args }
    }

    if (Array.isArray(args)) {
        args = {
            root_number: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        root_number: args.root_number,
    }

    return getInterpretation.definition.url
            .replace('{root_number}', parsedArgs.root_number.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\NumerologyController::getInterpretation
* @see app/Http/Controllers/Api/NumerologyController.php:62
* @route '/api/interpretations/{root_number}'
*/
getInterpretation.get = (args: { root_number: string | number } | [root_number: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getInterpretation.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::getInterpretation
* @see app/Http/Controllers/Api/NumerologyController.php:62
* @route '/api/interpretations/{root_number}'
*/
getInterpretation.head = (args: { root_number: string | number } | [root_number: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getInterpretation.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::getInterpretation
* @see app/Http/Controllers/Api/NumerologyController.php:62
* @route '/api/interpretations/{root_number}'
*/
const getInterpretationForm = (args: { root_number: string | number } | [root_number: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getInterpretation.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::getInterpretation
* @see app/Http/Controllers/Api/NumerologyController.php:62
* @route '/api/interpretations/{root_number}'
*/
getInterpretationForm.get = (args: { root_number: string | number } | [root_number: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getInterpretation.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::getInterpretation
* @see app/Http/Controllers/Api/NumerologyController.php:62
* @route '/api/interpretations/{root_number}'
*/
getInterpretationForm.head = (args: { root_number: string | number } | [root_number: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getInterpretation.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

getInterpretation.form = getInterpretationForm

/**
* @see \App\Http\Controllers\Api\NumerologyController::saveCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:86
* @route '/api/save-calculation'
*/
export const saveCalculation = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: saveCalculation.url(options),
    method: 'post',
})

saveCalculation.definition = {
    methods: ["post"],
    url: '/api/save-calculation',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\NumerologyController::saveCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:86
* @route '/api/save-calculation'
*/
saveCalculation.url = (options?: RouteQueryOptions) => {
    return saveCalculation.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\NumerologyController::saveCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:86
* @route '/api/save-calculation'
*/
saveCalculation.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: saveCalculation.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::saveCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:86
* @route '/api/save-calculation'
*/
const saveCalculationForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: saveCalculation.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::saveCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:86
* @route '/api/save-calculation'
*/
saveCalculationForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: saveCalculation.url(options),
    method: 'post',
})

saveCalculation.form = saveCalculationForm

/**
* @see \App\Http\Controllers\Api\NumerologyController::getUserCalculations
* @see app/Http/Controllers/Api/NumerologyController.php:131
* @route '/api/my-calculations'
*/
export const getUserCalculations = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getUserCalculations.url(options),
    method: 'get',
})

getUserCalculations.definition = {
    methods: ["get","head"],
    url: '/api/my-calculations',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\NumerologyController::getUserCalculations
* @see app/Http/Controllers/Api/NumerologyController.php:131
* @route '/api/my-calculations'
*/
getUserCalculations.url = (options?: RouteQueryOptions) => {
    return getUserCalculations.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\NumerologyController::getUserCalculations
* @see app/Http/Controllers/Api/NumerologyController.php:131
* @route '/api/my-calculations'
*/
getUserCalculations.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getUserCalculations.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::getUserCalculations
* @see app/Http/Controllers/Api/NumerologyController.php:131
* @route '/api/my-calculations'
*/
getUserCalculations.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getUserCalculations.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::getUserCalculations
* @see app/Http/Controllers/Api/NumerologyController.php:131
* @route '/api/my-calculations'
*/
const getUserCalculationsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getUserCalculations.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::getUserCalculations
* @see app/Http/Controllers/Api/NumerologyController.php:131
* @route '/api/my-calculations'
*/
getUserCalculationsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getUserCalculations.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::getUserCalculations
* @see app/Http/Controllers/Api/NumerologyController.php:131
* @route '/api/my-calculations'
*/
getUserCalculationsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getUserCalculations.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

getUserCalculations.form = getUserCalculationsForm

/**
* @see \App\Http\Controllers\Api\NumerologyController::deleteCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:151
* @route '/api/calculations/{id}'
*/
export const deleteCalculation = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteCalculation.url(args, options),
    method: 'delete',
})

deleteCalculation.definition = {
    methods: ["delete"],
    url: '/api/calculations/{id}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Api\NumerologyController::deleteCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:151
* @route '/api/calculations/{id}'
*/
deleteCalculation.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return deleteCalculation.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\NumerologyController::deleteCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:151
* @route '/api/calculations/{id}'
*/
deleteCalculation.delete = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteCalculation.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::deleteCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:151
* @route '/api/calculations/{id}'
*/
const deleteCalculationForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteCalculation.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\NumerologyController::deleteCalculation
* @see app/Http/Controllers/Api/NumerologyController.php:151
* @route '/api/calculations/{id}'
*/
deleteCalculationForm.delete = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteCalculation.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

deleteCalculation.form = deleteCalculationForm

const NumerologyController = { calculate, getInterpretation, saveCalculation, getUserCalculations, deleteCalculation }

export default NumerologyController